/**

 * ...

 * @author Takahiro Miyazawa

 */



var Util = 

{

	setNodeProperties : function(opt, node)

	{

		if(opt.position != undefined) node.setPosition(opt.position);

		if(opt.x != undefined) node.setPositionX(opt.x);

		if(opt.y != undefined) node.setPositionY(opt.y);

		if(opt.scale != undefined) node.setScale(opt.scale);

		if(opt.scaleX != undefined) node.setScaleX(opt.scaleX);

		if(opt.scaleY != undefined) node.setScaleY(opt.scaleY);

		if(opt.rotation != undefined) node.setRotation(opt.rotation);

		if(opt.visible != undefined) node.setVisible(opt.visible);

		if(opt.opacity != undefined) node.setOpacity(opt.opacity);

	},

	

	createNode : function(parent, opt)

	{

		var node = cc.Node.create();

		parent.addChild(node);

		if(opt != undefined) Util.setNodeProperties(opt, node);

		

		return node;

	},

	

	createSprite : function(node, texture, rect, opt)

	{

		var sprite = cc.Sprite.create(texture, rect);

		node.addChild(sprite);

		if(opt != undefined) Util.setNodeProperties(opt, sprite);

		

		return sprite;

	},

	

	createMenu : function(node, centering)

	{

		if(centering == undefined) centering = true;

		

		var menu = cc.Menu.create();

		node.addChild(menu);

		if(! centering) menu.setPosition(cc.p(0,0));

		

		return menu;

	},

	

	createMenuItemSprite : function(menu, texture, rect, opt, onPressFunction, target)

	{

		if(target == undefined)

		{

			target = onPressFunction;

			onPressFunction = opt;

			opt = undefined;

		}

		

		var sprite = cc.Sprite.create(texture,rect);

		var sprite2 = cc.Sprite.create(texture,rect);

		sprite2.color = cc.color(110,210,238,255);

		

		var menuItem = cc.MenuItemSprite.create(sprite, sprite2, onPressFunction, target);

		menu.addChild(menuItem);

		if(opt != undefined) Util.setNodeProperties(opt, menuItem);

		

		return menuItem;

	},

	

	createMenuItemImage : function(menu, texture, press_texture, opt, onPressFunction, target)

	{

		if(press_texture == undefined) press_texture = texture;

		

		var menuItem = cc.MenuItemImage.create(texture, press_texture, onPressFunction);

		menu.addChild(menuItem);

		if(opt != undefined) Util.setNodeProperties(opt, menuItem);

		

		return menuItem;

	},

	

	createLabel : function(node, text, color, opt, size, fontType)

	{

		if(color == undefined) color = cc.color(0,0,0,255);

		if(size == undefined) size = 30;

		if(fontType == undefined) fontType = "Arial";

		var label = cc.LabelTTF.create(text, fontType, size);

		label.color = color;

		node.addChild(label);

		if(opt != undefined) Util.setNodeProperties(opt, label);

		

		return label;

	},

	

	createTexture : function(fileName)

	{

		var texture = cc.textureCache.getTextureForKey(fileName);

		if(! texture) texture = cc.textureCache.addImage(fileName);

		return texture;

	},

	

	tweet : function(text, hashTag)

	{

		window.open( "https://twitter.com/intent/tweet?text=" + encodeURIComponent(text) + "&hashtags=" + hashTag);

	},

	

	getCookie : function(key)

	{

		var tmp1 = " " + document.cookie + ";";

		var xx1 = 0;

		var xx2 = 0;

		len = tmp1.length;

		while (xx1 < len) {

			xx2 = tmp1.indexOf(";", xx1);

			var tmp2 = tmp1.substring(xx1 + 1, xx2);

			var xx3 = tmp2.indexOf("=");

			if (tmp2.substring(0, xx3) == key) {

				return(unescape(tmp2.substring(xx3 + 1, xx2 - xx1 - 1)));

			}

			xx1 = xx2 + 1;

		}

		return("");

	},

	

	setCookie : function(key, val)

	{

		var tmp = key + "=" + escape(val) + "; ";

		tmp += "expires=Tue, 31-Dec-2030 23:59:59; ";

		document.cookie = tmp;

	},

	

	resetCookie : function(key)

	{

		var tmp = key + "=" + "0; ";

		tmp += "expires=Fri, 31-Dec-1999 23:59:59 GMT;";

		document.cookie = tmp;

	},

	

	indexOf: function(str, _char)

	{

		for(var i = 0 ; i < str.length ; i ++)

		{

			if(str.charAt(i) == _char) return i;

		}

		return -1;

	},

	

};



var M_NODE = Util.createNode;

var M_SPRITE = Util.createSprite;

var M_MENU = Util.createMenu;

var M_MENU_ITEM_SPRITE = Util.createMenuItemSprite;

var M_MENU_ITEM_IMAGE = Util.createMenuItemImage;

var M_LABEL = Util.createLabel;

var M_TEXTURE = Util.createTexture;

var M_TWEET = Util.tweet;

var M_GET_COOKIE = Util.getCookie;

var M_SET_COOKIE = Util.setCookie;

var M_RESET_COOKIE = Util.resetCookie;

var M_INDEXOF = Util.indexOf;

